	 function [P, Z, Zinf] = MAKE_CAUSAL(P, Z)
 
	 % Makes a transfer function causal by adding poles at the origin and zeros 
	 % at infinity so that the number of poles = zeros
	 
	 % 	Toolbox for DIGITAL FILTERS USING MATLAB
	 
	 % Author: 			Lars Wanhammar 2004-11-15
	 % Modified by: 	 
	 % Copyright:		by authors - not released for commercial use
	 % Version:			1 
	 % Known bugs:		
	 % Report bugs to:	Wanhammar@gmail.com
	 
	 Zinf = 0;
	 Pzeros = [];
	 if (length(P) > length(Z))
		 Zinf = length(P) - length(Z) % Number of zeros at infinity
	 end
	 if (length(P) < length(Z))
		 Patzero = zeros(length(Z) - length(P), 1); % Add poles at 0
		 P = cat(2, P, Patzero);
	 end
